#include <iostream>
#include <vector>
#include <climits>

using namespace std;

long long izracunajSnagu(vector<int>& mnozitelji, vector<int>& dodaci, vector<int>& donjeGranice, vector<int>& gornjeGranice, int pocetnaSnaga, int brojPrepreka) {
    long long trenutnaSnaga = pocetnaSnaga;
    for (int i = 0; i < brojPrepreka; i++) {
        long long snagaPosleMnozenja = trenutnaSnaga * mnozitelji[i];
        long long snagaPosleDodatka = trenutnaSnaga + dodaci[i];
        long long novaSnaga = LLONG_MIN;

        if (snagaPosleMnozenja >= donjeGranice[i] && snagaPosleMnozenja <= gornjeGranice[i])
            novaSnaga = max(novaSnaga, snagaPosleMnozenja);

        if (snagaPosleDodatka >= donjeGranice[i] && snagaPosleDodatka <= gornjeGranice[i])
            novaSnaga = max(novaSnaga, snagaPosleDodatka);

        if (novaSnaga == LLONG_MIN) return LLONG_MIN;

        trenutnaSnaga = novaSnaga;
    }
    return trenutnaSnaga;
}

int main() {
    int brojEtapa;
    cin >> brojEtapa;

    while (brojEtapa--) {
        int brojPrepreka, startnaSnaga;
        cin >> brojPrepreka >> startnaSnaga;

        vector<int> mnozitelji(brojPrepreka), dodaci(brojPrepreka), donjeGranice(brojPrepreka), gornjeGranice(brojPrepreka);

        for (int i = 0; i < brojPrepreka; i++) cin >> mnozitelji[i];
        for (int i = 0; i < brojPrepreka; i++) cin >> dodaci[i];
        for (int i = 0; i < brojPrepreka; i++) cin >> donjeGranice[i];
        for (int i = 0; i < brojPrepreka; i++) cin >> gornjeGranice[i];

        long long krajnjaSnaga = izracunajSnagu(mnozitelji, dodaci, donjeGranice, gornjeGranice, startnaSnaga, brojPrepreka);

        if (krajnjaSnaga == LLONG_MIN) {
            cout << "nemoguce\n";
        } else {
            cout << krajnjaSnaga << "\n";
        }
    }

    return 0;
}